/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client.ui.widget.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.compactmods.crafting.client.ui.UiHelper;
import dev.compactmods.crafting.client.ui.widget.renderable.IWidgetPostBackgroundRenderable;
import dev.compactmods.crafting.client.ui.widget.renderable.IWidgetPreBackgroundRenderable;
import dev.compactmods.crafting.client.ui.widget.tab.EnumTabWidgetSide;
import dev.compactmods.crafting.client.ui.widget.tab.TabsWidget;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class GuiTab
implements Widget,
GuiEventListener,
IWidgetPreBackgroundRenderable,
IWidgetPostBackgroundRenderable {
    protected final ResourceLocation TEXTURE = new ResourceLocation("compactcrafting", "textures/gui/widget/tabs.png");
    private final ItemRenderer itemRenderer;
    private final Font fontRenderer;
    private TabsWidget container;
    private boolean isAlignedRight;
    private ItemStack icon;
    protected Vec2 screenPosition;
    private Consumer<GuiTab> clickHandler;

    public GuiTab(TabsWidget container, ItemStack icon) {
        this.container = container;
        this.isAlignedRight = false;
        this.icon = icon;
        Minecraft mc = Minecraft.m_91087_();
        this.itemRenderer = mc.m_91291_();
        this.fontRenderer = mc.f_91062_;
        this.container.addTab(this);
    }

    public GuiTab onClicked(Consumer<GuiTab> handler) {
        this.clickHandler = handler;
        return this;
    }

    public GuiTab onRight() {
        this.isAlignedRight = true;
        this.container.layout();
        return this;
    }

    public void setPosition(Vec2 screenPosition) {
        this.screenPosition = screenPosition;
    }

    public int getHeight() {
        return 28;
    }

    public int getWidth() {
        return 28;
    }

    public boolean isOver(double mouseX, double mouseY) {
        return UiHelper.pointInBounds(mouseX, mouseY, this.screenPosition.f_82470_, this.screenPosition.f_82471_, this.getWidth(), this.getHeight());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.container.setActiveTab(this);
        if (this.clickHandler != null) {
            this.clickHandler.accept(this);
        }
        return true;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
    }

    protected void renderTabButton(PoseStack matrix, boolean isActive, boolean topRow, boolean rightAligned, ItemStack icon) {
        Vec2 tabPos = this.screenPosition;
        int uvU = 0;
        int uvV = 0;
        float renderPosX = tabPos.f_82470_;
        float renderPosY = tabPos.f_82471_;
        if (isActive) {
            uvV += 32;
        }
        if (rightAligned) {
            uvU = 56;
        } else if (tabPos.f_82470_ > 0.0f) {
            uvU = 28;
        }
        if (topRow) {
            renderPosY -= 28.0f;
        } else {
            uvV += 64;
            renderPosY -= 4.0f;
        }
        RenderSystem.m_69478_();
        GuiComponent.m_93143_((PoseStack)matrix, (int)((int)renderPosX), (int)((int)renderPosY), (int)0, (float)uvU, (float)uvV, (int)28, (int)32, (int)256, (int)256);
    }

    @Override
    public void renderPostBackground(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.container.isActive(this)) {
            matrixStack.m_85836_();
            Minecraft.m_91087_().m_91097_().m_174784_(this.TEXTURE);
            this.renderTabButton(matrixStack, true, this.container.getSide() == EnumTabWidgetSide.TOP, this.isAlignedRight, this.icon);
            matrixStack.m_85849_();
        }
    }

    @Override
    public void renderPreBackground(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.container.isActive(this)) {
            Minecraft.m_91087_().m_91097_().m_174784_(this.TEXTURE);
            this.renderTabButton(matrixStack, false, this.container.getSide() == EnumTabWidgetSide.TOP, this.isAlignedRight, this.icon);
        }
    }

    public boolean isOnRight() {
        return this.isAlignedRight;
    }
}

